/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Formatter;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import org.springframework.format.annotation.NumberFormat;
import org.springframework.format.number.CurrencyFormatter;
import org.springframework.format.number.NumberFormatter;
import org.springframework.format.number.PercentFormatter;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberFormatAnnotationFormatterFactory
implements AnnotationFormatterFactory<NumberFormat>,
EmbeddedValueResolverAware {
    private final Set<Class<?>> fieldTypes;
    private StringValueResolver embeddedValueResolver;

    public NumberFormatAnnotationFormatterFactory() {
        HashSet<Class<BigInteger>> rawFieldTypes = new HashSet<Class<BigInteger>>(7);
        rawFieldTypes.add(Short.class);
        rawFieldTypes.add(Integer.class);
        rawFieldTypes.add(Long.class);
        rawFieldTypes.add(Float.class);
        rawFieldTypes.add(Double.class);
        rawFieldTypes.add(BigDecimal.class);
        rawFieldTypes.add(BigInteger.class);
        this.fieldTypes = Collections.unmodifiableSet(rawFieldTypes);
    }

    @Override
    public final Set<Class<?>> getFieldTypes() {
        return this.fieldTypes;
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    protected String resolveEmbeddedValue(String value) {
        return this.embeddedValueResolver != null ? this.embeddedValueResolver.resolveStringValue(value) : value;
    }

    @Override
    public Printer<Number> getPrinter(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    @Override
    public Parser<Number> getParser(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    private Formatter<Number> configureFormatterFrom(NumberFormat annotation) {
        if (StringUtils.hasLength(annotation.pattern())) {
            return new NumberFormatter(this.resolveEmbeddedValue(annotation.pattern()));
        }
        NumberFormat.Style style = annotation.style();
        if (style == NumberFormat.Style.PERCENT) {
            return new PercentFormatter();
        }
        if (style == NumberFormat.Style.CURRENCY) {
            return new CurrencyFormatter();
        }
        return new NumberFormatter();
    }
}

