/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodFilter;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.expression.spel.support.ReflectiveMethodExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveMethodResolver
implements MethodResolver {
    private static Method[] NO_METHODS = new Method[0];
    private Map<Class<?>, MethodFilter> filters = null;
    private boolean useDistance = false;

    public ReflectiveMethodResolver() {
    }

    public ReflectiveMethodResolver(boolean useDistance) {
        this.useDistance = useDistance;
    }

    @Override
    public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
        try {
            MethodFilter filter;
            TypeConverter typeConverter = context.getTypeConverter();
            Class<?> type = targetObject instanceof Class ? (Class<?>)targetObject : targetObject.getClass();
            ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(this.getMethods(type, targetObject)));
            MethodFilter methodFilter = filter = this.filters != null ? this.filters.get(type) : null;
            if (filter != null) {
                ArrayList<Method> filtered = filter.filter(methods);
                ArrayList<Method> arrayList = methods = filtered instanceof ArrayList ? filtered : new ArrayList<Method>(filtered);
            }
            if (methods.size() > 1) {
                Collections.sort(methods, new Comparator<Method>(){

                    @Override
                    public int compare(Method m1, Method m2) {
                        int m1pl = m1.getParameterTypes().length;
                        int m2pl = m2.getParameterTypes().length;
                        return new Integer(m1pl).compareTo(m2pl);
                    }
                });
            }
            for (int i = 0; i < methods.size(); ++i) {
                methods.set(i, BridgeMethodResolver.findBridgedMethod((Method)methods.get(i)));
            }
            LinkedHashSet methodsToIterate = new LinkedHashSet(methods);
            Method closeMatch = null;
            int closeMatchDistance = Integer.MAX_VALUE;
            int[] argsToConvert = null;
            Method matchRequiringConversion = null;
            boolean multipleOptions = false;
            for (Method method : methodsToIterate) {
                if (!method.getName().equals(name)) continue;
                Class<?>[] paramTypes = method.getParameterTypes();
                ArrayList<TypeDescriptor> paramDescriptors = new ArrayList<TypeDescriptor>(paramTypes.length);
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramDescriptors.add(new TypeDescriptor(new MethodParameter(method, i)));
                }
                ReflectionHelper.ArgumentsMatchInfo matchInfo = null;
                if (method.isVarArgs() && argumentTypes.size() >= paramTypes.length - 1) {
                    matchInfo = ReflectionHelper.compareArgumentsVarargs(paramDescriptors, argumentTypes, typeConverter);
                } else if (paramTypes.length == argumentTypes.size()) {
                    matchInfo = ReflectionHelper.compareArguments(paramDescriptors, argumentTypes, typeConverter);
                }
                if (matchInfo == null) continue;
                if (matchInfo.kind == ReflectionHelper.ArgsMatchKind.EXACT) {
                    return new ReflectiveMethodExecutor(method, null);
                }
                if (matchInfo.kind == ReflectionHelper.ArgsMatchKind.CLOSE) {
                    if (!this.useDistance) {
                        closeMatch = method;
                        continue;
                    }
                    int matchDistance = ReflectionHelper.getTypeDifferenceWeight(paramDescriptors, argumentTypes);
                    if (matchDistance >= closeMatchDistance) continue;
                    closeMatchDistance = matchDistance;
                    closeMatch = method;
                    continue;
                }
                if (matchInfo.kind != ReflectionHelper.ArgsMatchKind.REQUIRES_CONVERSION) continue;
                if (matchRequiringConversion != null) {
                    multipleOptions = true;
                }
                argsToConvert = matchInfo.argsRequiringConversion;
                matchRequiringConversion = method;
            }
            if (closeMatch != null) {
                return new ReflectiveMethodExecutor(closeMatch, null);
            }
            if (matchRequiringConversion != null) {
                if (multipleOptions) {
                    throw new SpelEvaluationException(SpelMessage.MULTIPLE_POSSIBLE_METHODS, name);
                }
                return new ReflectiveMethodExecutor(matchRequiringConversion, argsToConvert);
            }
            return null;
        }
        catch (EvaluationException ex) {
            throw new AccessException("Failed to resolve method", ex);
        }
    }

    public void registerMethodFilter(Class<?> type, MethodFilter filter) {
        if (this.filters == null) {
            this.filters = new HashMap();
        }
        if (filter == null) {
            this.filters.remove(type);
        } else {
            this.filters.put(type, filter);
        }
    }

    private Method[] getMethods(Class<?> type, Object targetObject) {
        if (targetObject instanceof Class) {
            HashSet<Method> methods = new HashSet<Method>();
            methods.addAll(Arrays.asList(this.getMethods(type)));
            methods.addAll(Arrays.asList(this.getMethods(targetObject.getClass())));
            return methods.toArray(new Method[methods.size()]);
        }
        return this.getMethods(type);
    }

    protected Method[] getMethods(Class<?> type) {
        return type.getMethods();
    }
}

