/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;

public class PdfBoxGraphics2DCMYKColor
extends Color {
    private final float c;
    private final float m;
    private final float y;
    private final float k;
    private final PDColorSpace colorSpace;

    public PdfBoxGraphics2DCMYKColor(int c, int m, int y, int k, int alpha) {
        this((float)c / 255.0f, (float)m / 255.0f, (float)y / 255.0f, (float)k / 255.0f, alpha);
    }

    public PdfBoxGraphics2DCMYKColor(int c, int m, int y, int k) {
        this((float)c / 255.0f, (float)m / 255.0f, (float)y / 255.0f, (float)k / 255.0f);
    }

    public PdfBoxGraphics2DCMYKColor(float c, float m, float y, float k) {
        this(c, m, y, k, 255);
    }

    private static int toRGBValue(float c, float m, float y, float k, int alpha, PDColorSpace colorSpace) {
        try {
            float[] rgb = colorSpace.toRGB(new float[]{c, m, y, k});
            int r = (int)(rgb[0] * 255.0f) & 0xFF;
            int g = (int)(rgb[1] * 255.0f) & 0xFF;
            int b = (int)(rgb[2] * 255.0f) & 0xFF;
            return alpha << 24 | r << 16 | g << 8 | b;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PdfBoxGraphics2DCMYKColor(float c, float m, float y, float k, int alpha) {
        this(c, m, y, k, alpha, PDDeviceCMYK.INSTANCE);
    }

    public PdfBoxGraphics2DCMYKColor(float c, float m, float y, float k, int alpha, PDColorSpace colorSpace) {
        super(PdfBoxGraphics2DCMYKColor.toRGBValue(c, m, y, k, alpha, colorSpace), true);
        this.c = c;
        this.m = m;
        this.y = y;
        this.k = k;
        this.colorSpace = colorSpace;
    }

    public float getC() {
        return this.c;
    }

    public float getM() {
        return this.m;
    }

    public float getY() {
        return this.y;
    }

    public float getK() {
        return this.k;
    }

    public PDColor toPDColor() {
        return new PDColor(new float[]{this.getC(), this.getM(), this.getY(), this.getK()}, this.colorSpace);
    }
}

