/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.pdfboxout.PdfBoxLinkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxReplacedElement;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.swing.ImageMapParser;
import com.openhtmltopdf.util.XRLog;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.w3c.dom.Element;

public class PdfBoxPDFReplacedElement
implements PdfBoxReplacedElement,
PdfBoxLinkManager.IPdfBoxElementWithShapedLinks {
    private final PDFormXObject _srcFormObject;
    private final float _width;
    private final float _height;
    private final Map<Shape, String> _imageMap;
    private Point _location = new Point(0, 0);

    private PdfBoxPDFReplacedElement(PDFormXObject srcForm, Element e, Box box, CssContext ctx, SharedContext shared, float w, float h) {
        this._srcFormObject = srcForm;
        this._width = w;
        this._height = h;
        this._imageMap = ImageMapParser.findAndParseMap(e, shared);
    }

    private static int parsePage(Element e) {
        if (e.getAttribute("page").isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(e.getAttribute("page")) - 1;
        }
        catch (NumberFormatException e1) {
            XRLog.exception("Unable to parse page of img tag with PDF!", e1);
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PdfBoxPDFReplacedElement create(PDDocument target, byte[] pdfBytes, Element e, Box box, CssContext ctx, SharedContext shared) {
        try (PDDocument srcDocument = PDDocument.load(pdfBytes);){
            int pageNo = PdfBoxPDFReplacedElement.parsePage(e);
            if (pageNo >= srcDocument.getNumberOfPages()) {
                XRLog.load(Level.WARNING, "Page does not exist for pdf in img tag. Ignoring!");
                PdfBoxPDFReplacedElement pdfBoxPDFReplacedElement2 = null;
                return pdfBoxPDFReplacedElement2;
            }
            PDPage page = srcDocument.getPage(pageNo);
            float conversion = 1.3333334f;
            float width = page.getMediaBox().getWidth() * (float)shared.getDotsPerPixel() * conversion;
            float height = page.getMediaBox().getHeight() * (float)shared.getDotsPerPixel() * conversion;
            LayerUtility util = new LayerUtility(target);
            PDFormXObject formXObject = util.importPageAsForm(srcDocument, page);
            PdfBoxPDFReplacedElement pdfBoxPDFReplacedElement = new PdfBoxPDFReplacedElement(formXObject, e, box, ctx, shared, width, height);
            return pdfBoxPDFReplacedElement;
        }
        catch (InvalidPasswordException e1) {
            XRLog.exception("Tried to open a password protected document as src for an img!", e1);
            return null;
        }
        catch (IOException e1) {
            XRLog.exception("Could not read pdf passed as src for img element!", e1);
        }
        return null;
    }

    @Override
    public int getIntrinsicWidth() {
        return (int)this._width;
    }

    @Override
    public int getIntrinsicHeight() {
        return (int)this._height;
    }

    @Override
    public Point getLocation() {
        return this._location;
    }

    @Override
    public void setLocation(int x, int y) {
        this._location = new Point(x, y);
    }

    @Override
    public Map<Shape, String> getLinkMap() {
        return this._imageMap;
    }

    @Override
    public void detach(LayoutContext c) {
    }

    @Override
    public boolean isRequiresInteractivePaint() {
        return false;
    }

    @Override
    public void paint(RenderingContext c, PdfBoxOutputDevice outputDevice, BlockBox box) {
        Rectangle contentBounds = box.getContentAreaEdge(box.getAbsX(), box.getAbsY(), c);
        outputDevice.drawPdfAsImage(this._srcFormObject, contentBounds, this.getIntrinsicWidth(), this.getIntrinsicHeight());
    }

    @Override
    public int getBaseline() {
        return 0;
    }

    @Override
    public boolean hasBaseline() {
        return false;
    }
}

