/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import sun.management.GarbageCollectionNotifInfoCompositeData;
import sun.management.GcInfoBuilder;
import sun.management.MemoryManagerImpl;
import sun.management.Util;

class GarbageCollectorImpl
extends MemoryManagerImpl
implements GarbageCollectorMXBean {
    private String[] poolNames = null;
    private GcInfoBuilder gcInfoBuilder;
    private static final String notifName = "javax.management.Notification";
    private static final String[] gcNotifTypes = new String[]{"com.sun.management.gc.notification"};
    private MBeanNotificationInfo[] notifInfo = null;
    private static long seqNumber = 0L;

    GarbageCollectorImpl(String string) {
        super(string);
    }

    @Override
    public native long getCollectionCount();

    @Override
    public native long getCollectionTime();

    synchronized String[] getAllPoolNames() {
        if (this.poolNames == null) {
            List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
            this.poolNames = new String[list.size()];
            int n = 0;
            for (MemoryPoolMXBean memoryPoolMXBean : list) {
                this.poolNames[n++] = memoryPoolMXBean.getName();
            }
        }
        return this.poolNames;
    }

    private synchronized GcInfoBuilder getGcInfoBuilder() {
        if (this.gcInfoBuilder == null) {
            this.gcInfoBuilder = new GcInfoBuilder(this, this.getAllPoolNames());
        }
        return this.gcInfoBuilder;
    }

    @Override
    public GcInfo getLastGcInfo() {
        GcInfo gcInfo = this.getGcInfoBuilder().getLastGcInfo();
        return gcInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        GarbageCollectorImpl garbageCollectorImpl = this;
        synchronized (garbageCollectorImpl) {
            if (this.notifInfo == null) {
                this.notifInfo = new MBeanNotificationInfo[1];
                this.notifInfo[0] = new MBeanNotificationInfo(gcNotifTypes, notifName, "GC Notification");
            }
        }
        return this.notifInfo;
    }

    private static long getNextSeqNumber() {
        return ++seqNumber;
    }

    void createGCNotification(long l, String string, String string2, String string3, GcInfo gcInfo) {
        if (!this.hasListeners()) {
            return;
        }
        Notification notification = new Notification("com.sun.management.gc.notification", this.getObjectName(), GarbageCollectorImpl.getNextSeqNumber(), l, string);
        GarbageCollectionNotificationInfo garbageCollectionNotificationInfo = new GarbageCollectionNotificationInfo(string, string2, string3, gcInfo);
        CompositeData compositeData = GarbageCollectionNotifInfoCompositeData.toCompositeData(garbageCollectionNotificationInfo);
        notification.setUserData(compositeData);
        this.sendNotification(notification);
    }

    @Override
    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        boolean bl = this.hasListeners();
        super.addNotificationListener(notificationListener, notificationFilter, object);
        boolean bl2 = this.hasListeners();
        if (!bl && bl2) {
            this.setNotificationEnabled(this, true);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        boolean bl = this.hasListeners();
        super.removeNotificationListener(notificationListener);
        boolean bl2 = this.hasListeners();
        if (bl && !bl2) {
            this.setNotificationEnabled(this, false);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        boolean bl = this.hasListeners();
        super.removeNotificationListener(notificationListener, notificationFilter, object);
        boolean bl2 = this.hasListeners();
        if (bl && !bl2) {
            this.setNotificationEnabled(this, false);
        }
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=GarbageCollector", this.getName());
    }

    native void setNotificationEnabled(GarbageCollectorMXBean var1, boolean var2);
}

