/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.util.Collections;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderContentNegotiationStrategy
implements ContentNegotiationStrategy {
    private static final String ACCEPT_HEADER = "Accept";

    @Override
    public List<MediaType> resolveMediaTypes(NativeWebRequest webRequest) throws HttpMediaTypeNotAcceptableException {
        String acceptHeader = webRequest.getHeader(ACCEPT_HEADER);
        try {
            if (StringUtils.hasText(acceptHeader)) {
                List<MediaType> mediaTypes = MediaType.parseMediaTypes(acceptHeader);
                MediaType.sortBySpecificityAndQuality(mediaTypes);
                return mediaTypes;
            }
        }
        catch (IllegalArgumentException ex) {
            throw new HttpMediaTypeNotAcceptableException("Could not parse accept header [" + acceptHeader + "]: " + ex.getMessage());
        }
        return Collections.emptyList();
    }
}

