/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.module;

import com.beust.jcommander.JCommander;
import com.ncloud.api.cli.autoscaling.options.CreateAutoScalingGroupOptions;
import com.ncloud.api.cli.autoscaling.options.CreateLaunchConfigurationOptions;
import com.ncloud.api.cli.autoscaling.options.DeleteAutoScalingGroupOptions;
import com.ncloud.api.cli.autoscaling.options.DeleteAutoScalingLaunchConfigurationOptions;
import com.ncloud.api.cli.autoscaling.options.DeletePolicyOptions;
import com.ncloud.api.cli.autoscaling.options.DeleteScheduledActionOptions;
import com.ncloud.api.cli.autoscaling.options.ExecutePolicyOptions;
import com.ncloud.api.cli.autoscaling.options.GetAdjustmentTypeListOptions;
import com.ncloud.api.cli.autoscaling.options.GetAutoScalingActivityLogListOptions;
import com.ncloud.api.cli.autoscaling.options.GetAutoScalingConfigurationLogListOptions;
import com.ncloud.api.cli.autoscaling.options.GetAutoScalingGroupListOptions;
import com.ncloud.api.cli.autoscaling.options.GetAutoScalingPolicyListOptions;
import com.ncloud.api.cli.autoscaling.options.GetLaunchConfigurationListOptions;
import com.ncloud.api.cli.autoscaling.options.GetScalingProcessTypeListOptions;
import com.ncloud.api.cli.autoscaling.options.GetScheduledActionListOptions;
import com.ncloud.api.cli.autoscaling.options.PutScalingPolicyOptions;
import com.ncloud.api.cli.autoscaling.options.PutScheduledUpdateGroupActionOptions;
import com.ncloud.api.cli.autoscaling.options.ResumeProcessesOptions;
import com.ncloud.api.cli.autoscaling.options.SetDesiredCapacityOptions;
import com.ncloud.api.cli.autoscaling.options.SetServerInstanceHealthOptions;
import com.ncloud.api.cli.autoscaling.options.SuspendProcessesOptions;
import com.ncloud.api.cli.autoscaling.options.TerminateServerInstanceInAutoScalingGroupOptions;
import com.ncloud.api.cli.autoscaling.options.UpdateAutoScalingGroupOptions;
import com.ncloud.api.cli.common.model.CommandEnum;
import com.ncloud.api.cli.common.model.CommandOption;
import com.ncloud.api.cli.common.options.GlobalOptions;
import com.ncloud.api.cli.common.util.CliCallUtil;
import com.ncloud.api.cli.common.util.CommandUtil;
import com.ncloud.api.cli.common.util.GlobalOptionUtil;
import com.ncloud.api.cli.exception.NcloudCliException;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Autoscaling {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void execute(JCommander autoscalingCommander, CommandEnum.AutoscalingCommand autoscalingCommand) throws NcloudCliException, UnsupportedEncodingException {
        JCommander subCommander = autoscalingCommander.getCommands().get(autoscalingCommand.getCode());
        CommandOption commandOption = null;
        String requestUri = null;
        switch (autoscalingCommand) {
            case getLaunchConfigurationList: {
                requestUri = "/autoscaling/v2/getLaunchConfigurationList";
                commandOption = (GetLaunchConfigurationListOptions)subCommander.getObjects().get(0);
                break;
            }
            case createLaunchConfiguration: {
                requestUri = "/autoscaling/v2/createLaunchConfiguration";
                commandOption = (CreateLaunchConfigurationOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteAutoScalingLaunchConfiguration: {
                requestUri = "/autoscaling/v2/deleteAutoScalingLaunchConfiguration";
                commandOption = (DeleteAutoScalingLaunchConfigurationOptions)subCommander.getObjects().get(0);
                break;
            }
            case getAutoScalingGroupList: {
                requestUri = "/autoscaling/v2/getAutoScalingGroupList";
                commandOption = (GetAutoScalingGroupListOptions)subCommander.getObjects().get(0);
                break;
            }
            case createAutoScalingGroup: {
                requestUri = "/autoscaling/v2/createAutoScalingGroup";
                commandOption = (CreateAutoScalingGroupOptions)subCommander.getObjects().get(0);
                break;
            }
            case updateAutoScalingGroup: {
                requestUri = "/autoscaling/v2/updateAutoScalingGroup";
                commandOption = (UpdateAutoScalingGroupOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteAutoScalingGroup: {
                requestUri = "/autoscaling/v2/deleteAutoScalingGroup";
                commandOption = (DeleteAutoScalingGroupOptions)subCommander.getObjects().get(0);
                break;
            }
            case setDesiredCapacity: {
                requestUri = "/autoscaling/v2/setDesiredCapacity";
                commandOption = (SetDesiredCapacityOptions)subCommander.getObjects().get(0);
                break;
            }
            case terminateServerInstanceInAutoScalingGroup: {
                requestUri = "/autoscaling/v2/terminateServerInstanceInAutoScalingGroup";
                commandOption = (TerminateServerInstanceInAutoScalingGroupOptions)subCommander.getObjects().get(0);
                break;
            }
            case setServerInstanceHealth: {
                requestUri = "/autoscaling/v2/setServerInstanceHealth";
                commandOption = (SetServerInstanceHealthOptions)subCommander.getObjects().get(0);
                break;
            }
            case getScheduledActionList: {
                requestUri = "/autoscaling/v2/getScheduledActionList";
                commandOption = (GetScheduledActionListOptions)subCommander.getObjects().get(0);
                break;
            }
            case putScheduledUpdateGroupAction: {
                requestUri = "/autoscaling/v2/putScheduledUpdateGroupAction";
                commandOption = (PutScheduledUpdateGroupActionOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteScheduledAction: {
                requestUri = "/autoscaling/v2/deleteScheduledAction";
                commandOption = (DeleteScheduledActionOptions)subCommander.getObjects().get(0);
                break;
            }
            case suspendProcesses: {
                requestUri = "/autoscaling/v2/suspendProcesses";
                commandOption = (SuspendProcessesOptions)subCommander.getObjects().get(0);
                break;
            }
            case resumeProcesses: {
                requestUri = "/autoscaling/v2/resumeProcesses";
                commandOption = (ResumeProcessesOptions)subCommander.getObjects().get(0);
                break;
            }
            case getScalingProcessTypeList: {
                requestUri = "/autoscaling/v2/getScalingProcessTypeList";
                commandOption = (GetScalingProcessTypeListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getAutoScalingActivityLogList: {
                requestUri = "/autoscaling/v2/getAutoScalingActivityLogList";
                commandOption = (GetAutoScalingActivityLogListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getAutoScalingConfigurationLogList: {
                requestUri = "/autoscaling/v2/getAutoScalingConfigurationLogList";
                commandOption = (GetAutoScalingConfigurationLogListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getAutoScalingPolicyList: {
                requestUri = "/autoscaling/v2/getAutoScalingPolicyList";
                commandOption = (GetAutoScalingPolicyListOptions)subCommander.getObjects().get(0);
                break;
            }
            case putScalingPolicy: {
                requestUri = "/autoscaling/v2/putScalingPolicy";
                commandOption = (PutScalingPolicyOptions)subCommander.getObjects().get(0);
                break;
            }
            case deletePolicy: {
                requestUri = "/autoscaling/v2/deletePolicy";
                commandOption = (DeletePolicyOptions)subCommander.getObjects().get(0);
                break;
            }
            case executePolicy: {
                requestUri = "/autoscaling/v2/executePolicy";
                commandOption = (ExecutePolicyOptions)subCommander.getObjects().get(0);
                break;
            }
            case getAdjustmentTypeList: {
                requestUri = "/autoscaling/v2/getAdjustmentTypeList";
                commandOption = (GetAdjustmentTypeListOptions)subCommander.getObjects().get(0);
                break;
            }
        }
        if (null != requestUri) {
            GlobalOptions globalOptions = commandOption.getCommandOptions().getGlobalOptions();
            String profile = globalOptions.getProfile();
            boolean isDebug = GlobalOptionUtil.getIsDebug();
            if (profile == null) {
                profile = "DEFAULT";
            }
            CliCallUtil.call(globalOptions, CommandUtil.getNcloudNewApiRequest(profile, isDebug), requestUri, commandOption);
        }
    }
}

