/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.common.util;

import com.ncloud.api.cli.common.model.Constant;
import com.ncloud.api.cli.common.util.GlobalOptionUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public final class HttpConnectionUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpConnectionUtil.class);
    public int httpConnectionTimeout = 5000;

    public HttpConnectionUtil() {
    }

    public HttpConnectionUtil(int httpConnectionTimeout) {
        this.httpConnectionTimeout = httpConnectionTimeout;
    }

    public String postConnect(String requestURI, Map<String, Object> parameters, String encoding) throws IOException {
        String returnStr;
        block6: {
            HttpURLConnection con = null;
            URL url = null;
            returnStr = null;
            BufferedOutputStream os = null;
            try {
                url = new URL(requestURI);
                con = (HttpURLConnection)url.openConnection();
                con.setDoInput(true);
                con.setDoOutput(true);
                con.setUseCaches(false);
                con.setAllowUserInteraction(false);
                con.setConnectTimeout(this.httpConnectionTimeout);
                con.setRequestProperty("User-Agent", Constant.NCLOUD_CLI_VERSION);
                con.setRequestMethod("POST");
                String postParameter = HttpConnectionUtil.getPostParameter(parameters, encoding, null);
                logger.debug("requestURI=>" + requestURI);
                logger.debug("postParameter=>" + postParameter);
                os = new BufferedOutputStream(con.getOutputStream());
                os.write(postParameter.getBytes(encoding));
                os.flush();
                int responseCode = con.getResponseCode();
                logger.debug("responseCode => " + responseCode);
                if (responseCode == 200) {
                    returnStr = this.read(con, encoding);
                    break block6;
                }
                throw new RuntimeException("request : " + requestURI + ", parameters : " + postParameter + ", reponseCode : " + responseCode);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                con.disconnect();
            }
        }
        logger.debug("returnStr=>" + returnStr);
        return returnStr;
    }

    public String getConnect(String requestURI, String encoding) throws IOException {
        String returnStr;
        block6: {
            HttpURLConnection con = null;
            URL url = null;
            returnStr = null;
            try {
                url = new URL(requestURI);
                con = (HttpURLConnection)url.openConnection();
                con.setRequestProperty("User-Agent", Constant.NCLOUD_CLI_VERSION);
                con.setRequestMethod("GET");
                con.setConnectTimeout(this.httpConnectionTimeout);
                int responseCode = con.getResponseCode();
                logger.debug("responseCode => " + responseCode);
                if (responseCode == 200) {
                    returnStr = this.read(con, encoding);
                    break block6;
                }
                throw new RuntimeException("request : " + requestURI + ", reponseCode : " + responseCode);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                con.disconnect();
            }
        }
        logger.debug("returnStr=>" + returnStr);
        return returnStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String restCall(URI uri, String method, Map<String, Object> headers, Map<String, Object> params, Boolean isDebug, Integer connectionTimeout, Integer readTimeout) throws UnsupportedEncodingException, URISyntaxException {
        String resultContent = null;
        String queryString = HttpConnectionUtil.getPostParameter(params, "UTF-8", isDebug);
        HttpUriRequestBase httpUriRequestBase = new HttpUriRequestBase(method, uri);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("User-Agent", Constant.NCLOUD_CLI_VERSION);
        headers.forEach(httpUriRequestBase::addHeader);
        Map<String, String> postParams = HttpConnectionUtil.queryToMap(queryString);
        ArrayList nameValuePairList = new ArrayList();
        postParams.forEach((key, value) -> {
            if (value != null) {
                try {
                    nameValuePairList.add(new BasicNameValuePair((String)key, URLDecoder.decode(value.toString(), "UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        httpUriRequestBase.setEntity(new UrlEncodedFormEntity(nameValuePairList));
        if (isDebug.booleanValue()) {
            logger.info("uri-> " + uri);
            logger.info("method-> " + method);
            logger.info("headers-> " + headers);
            logger.info("params-> " + postParams);
        }
        Integer doConnectionTimeout = connectionTimeout != null ? connectionTimeout : GlobalOptionUtil.getConnectTimeout();
        Integer doReadTimeout = readTimeout != null ? readTimeout : GlobalOptionUtil.getReadTimeout();
        ConnectionConfig connConfig = ConnectionConfig.custom().setConnectTimeout(doConnectionTimeout.intValue(), TimeUnit.SECONDS).setSocketTimeout(doReadTimeout, TimeUnit.SECONDS).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds(doConnectionTimeout.intValue())).build();
        BasicHttpClientConnectionManager cm = new BasicHttpClientConnectionManager();
        cm.setConnectionConfig(connConfig);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager(cm).build();
        try (CloseableHttpResponse response = httpClient.execute(httpUriRequestBase);){
            HttpEntity entity = response.getEntity();
            if (response.getCode() == HttpStatus.UNAUTHORIZED.value()) {
                String string = "Invalid consumerKey";
                return string;
            }
            if (response.getCode() == HttpStatus.NOT_FOUND.value()) {
                String string = "Not found method";
                return string;
            }
            resultContent = EntityUtils.toString(entity);
            return resultContent;
        }
        catch (IOException | ParseException e) {
            if (e instanceof UnknownHostException) {
                return uri + " call failed. Please make sure it is the correct call path.";
            }
            if (e instanceof SocketTimeoutException) {
                return "Read timeout occurred.";
            }
            if (e instanceof ConnectionRequestTimeoutException) {
                return "Connection timeout occurred.";
            }
            if (isDebug == false) return "Unexpected error occured.";
            logger.error(e.getCause().toString());
            logger.error(e.getMessage());
            return "Unexpected error occured.";
        }
    }

    public static Map<String, String> queryToMap(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String param : query.split("&")) {
            String[] pair = param.split("=");
            if (pair.length > 1) {
                result.put(pair[0], pair[1]);
                continue;
            }
            result.put(pair[0], "");
        }
        return result;
    }

    public static String restCall(URI uri, String method, Map<String, Object> headers, Map<String, Object> params, Boolean isDebug) throws UnsupportedEncodingException, URISyntaxException {
        return HttpConnectionUtil.restCall(uri, method, headers, params, isDebug, null, null);
    }

    private String read(HttpURLConnection connection, String encoding) throws IOException {
        BufferedReader resultReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
        StringBuffer buf = new StringBuffer();
        boolean firstLine = true;
        String readString = null;
        while ((readString = resultReader.readLine()) != null) {
            if (!firstLine) {
                buf.append("\n");
            }
            buf.append(readString);
            firstLine = false;
        }
        return buf.toString();
    }

    private static String appendParameterStringForList(ArrayList<Object> parameters, String encoding, String prefix) throws UnsupportedEncodingException {
        StringBuffer result = new StringBuffer();
        int idx = 0;
        int parameterSize = parameters.size();
        for (Object parameter : parameters) {
            if (parameter instanceof String) {
                result.append(prefix + (idx + 1) + "=" + URLEncoder.encode((String)parameter, encoding));
            } else if (parameter instanceof Boolean) {
                result.append(prefix + (idx + 1) + "=" + URLEncoder.encode(String.valueOf(parameter), encoding));
            } else if (parameter instanceof Integer) {
                result.append(prefix + (idx + 1) + "=" + URLEncoder.encode(String.valueOf(parameter), encoding));
            } else if (parameter instanceof Map) {
                Map map = (Map)parameter;
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() instanceof List) {
                        result.append(HttpConnectionUtil.appendParameterStringForList((ArrayList)entry.getValue(), encoding, prefix + (idx + 1) + "." + (String)entry.getKey() + "."));
                    } else if (entry.getValue() instanceof String) {
                        result.append(prefix + (idx + 1) + "." + (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), encoding));
                    } else if (entry.getValue() instanceof Boolean) {
                        result.append(prefix + (idx + 1) + "." + (String)entry.getKey() + "=" + URLEncoder.encode(String.valueOf(entry.getValue()), encoding));
                    } else if (entry.getValue() instanceof Number) {
                        Number num = (Number)entry.getValue();
                        DecimalFormat df = new DecimalFormat();
                        String numString = df.format(num);
                        numString = numString.replaceAll(",", "");
                        result.append(prefix + (idx + 1) + "." + (String)entry.getKey() + "=" + URLEncoder.encode(numString, encoding));
                    }
                    result.append("&");
                }
            } else if (parameter instanceof List) {
                result.append(HttpConnectionUtil.appendParameterStringForList((ArrayList)parameter, encoding, prefix + (idx + 1) + "."));
            }
            ++idx;
            result.append("&");
        }
        return result.toString();
    }

    private static String getPostParameter(Map<String, Object> parameters, String encoding, Boolean isDebug) throws UnsupportedEncodingException {
        StringBuffer postParameter = new StringBuffer();
        int parameterSize = parameters.entrySet().size();
        int idx = 0;
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (isDebug.booleanValue()) {
                logger.info("Parameter[" + idx + "]:" + entry.getKey() + ":" + entry.getValue());
            }
            if (entry.getValue() instanceof String) {
                postParameter.append(entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), encoding));
            } else if (entry.getValue() instanceof Boolean) {
                postParameter.append(entry.getKey() + "=" + URLEncoder.encode(String.valueOf(entry.getValue()), encoding));
            } else if (entry.getValue() instanceof Number) {
                Number num = (Number)entry.getValue();
                DecimalFormat df = new DecimalFormat();
                String numString = df.format(num);
                numString = numString.replaceAll(",", "");
                postParameter.append(entry.getKey() + "=" + URLEncoder.encode(numString, encoding));
            } else if (entry.getValue() instanceof List) {
                ArrayList objectList = (ArrayList)entry.getValue();
                String result = HttpConnectionUtil.appendParameterStringForList(objectList, encoding, entry.getKey() + ".");
                postParameter.append(result);
            }
            if (parameterSize == ++idx || entry.getValue() == null) continue;
            postParameter.append("&");
        }
        String result = postParameter.toString().replaceAll("&{2,}", "&");
        if (isDebug.booleanValue()) {
            logger.info(result);
        }
        return result;
    }

    public int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    public void setHttpConnectionTimeout(int httpConnectionTimeout) {
        this.httpConnectionTimeout = httpConnectionTimeout;
    }

    static enum METHOD {
        GET("GET"),
        PUT("PUT"),
        POST("POST");

        private String name;

        private METHOD(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

