/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import jdk.nashorn.internal.runtime.FunctionInitializer;

public final class StoredScript
implements Serializable {
    private final int compilationId;
    private final String mainClassName;
    private final Map<String, byte[]> classBytes;
    private final Object[] constants;
    private final Map<Integer, FunctionInitializer> initializers;
    private static final long serialVersionUID = 2958227232195298340L;

    public StoredScript(int compilationId, String mainClassName, Map<String, byte[]> classBytes, Map<Integer, FunctionInitializer> initializers, Object[] constants) {
        this.compilationId = compilationId;
        this.mainClassName = mainClassName;
        this.classBytes = classBytes;
        this.constants = constants;
        this.initializers = initializers;
    }

    public int getCompilationId() {
        return this.compilationId;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public Map<String, byte[]> getClassBytes() {
        LinkedHashMap<String, byte[]> clonedMap = new LinkedHashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> entry : this.classBytes.entrySet()) {
            clonedMap.put(entry.getKey(), (byte[])entry.getValue().clone());
        }
        return clonedMap;
    }

    public Object[] getConstants() {
        return (Object[])this.constants.clone();
    }

    public Map<Integer, FunctionInitializer> getInitializers() {
        LinkedHashMap<Integer, FunctionInitializer> clonedMap = new LinkedHashMap<Integer, FunctionInitializer>();
        for (Map.Entry<Integer, FunctionInitializer> entry : this.initializers.entrySet()) {
            clonedMap.put(entry.getKey(), new FunctionInitializer(entry.getValue()));
        }
        return clonedMap;
    }

    public int hashCode() {
        int hash = this.mainClassName.hashCode();
        hash = 31 * hash + this.classBytes.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.constants);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StoredScript)) {
            return false;
        }
        StoredScript cs = (StoredScript)obj;
        return this.mainClassName.equals(cs.mainClassName) && this.classBytes.equals(cs.classBytes) && Arrays.equals(this.constants, cs.constants);
    }
}

