/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectivePropertyAccessor
implements PropertyAccessor {
    private final Map<CacheKey, InvokerPair> readerCache = new ConcurrentHashMap<CacheKey, InvokerPair>(64);
    private final Map<CacheKey, Member> writerCache = new ConcurrentHashMap<CacheKey, Member>(64);
    private final Map<CacheKey, TypeDescriptor> typeDescriptorCache = new ConcurrentHashMap<CacheKey, TypeDescriptor>(64);

    public Class<?>[] getSpecificTargetClasses() {
        return null;
    }

    @Override
    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        Class<?> type;
        if (target == null) {
            return false;
        }
        Class<?> clazz = type = target instanceof Class ? (Class<?>)target : target.getClass();
        if (type.isArray() && name.equals("length")) {
            return true;
        }
        CacheKey cacheKey = new CacheKey(type, name);
        if (this.readerCache.containsKey(cacheKey)) {
            return true;
        }
        Method method = this.findGetterForProperty(name, type, target);
        if (method != null) {
            Property property = new Property(type, method, null);
            TypeDescriptor typeDescriptor = new TypeDescriptor(property);
            this.readerCache.put(cacheKey, new InvokerPair(method, typeDescriptor));
            this.typeDescriptorCache.put(cacheKey, typeDescriptor);
            return true;
        }
        Field field = this.findField(name, type, target);
        if (field != null) {
            TypeDescriptor typeDescriptor = new TypeDescriptor(field);
            this.readerCache.put(cacheKey, new InvokerPair(field, typeDescriptor));
            this.typeDescriptorCache.put(cacheKey, typeDescriptor);
            return true;
        }
        return false;
    }

    @Override
    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        Object value;
        Class<?> type;
        if (target == null) {
            throw new AccessException("Cannot read property of null target");
        }
        Class<?> clazz = type = target instanceof Class ? (Class<?>)target : target.getClass();
        if (type.isArray() && name.equals("length")) {
            if (target instanceof Class) {
                throw new AccessException("Cannot access length on array class itself");
            }
            return new TypedValue(Array.getLength(target));
        }
        CacheKey cacheKey = new CacheKey(type, name);
        InvokerPair invoker = this.readerCache.get(cacheKey);
        if (invoker == null || invoker.member instanceof Method) {
            Method method = (Method)(invoker != null ? invoker.member : null);
            if (method == null && (method = this.findGetterForProperty(name, type, target)) != null) {
                Property property = new Property(type, method, null);
                TypeDescriptor typeDescriptor = new TypeDescriptor(property);
                invoker = new InvokerPair(method, typeDescriptor);
                this.readerCache.put(cacheKey, invoker);
            }
            if (method != null) {
                try {
                    ReflectionUtils.makeAccessible(method);
                    value = method.invoke(target, new Object[0]);
                    return new TypedValue(value, invoker.typeDescriptor.narrow(value));
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access property '" + name + "' through getter", ex);
                }
            }
        }
        if (invoker == null || invoker.member instanceof Field) {
            Field field = (Field)(invoker == null ? null : invoker.member);
            if (field == null && (field = this.findField(name, type, target)) != null) {
                invoker = new InvokerPair(field, new TypeDescriptor(field));
                this.readerCache.put(cacheKey, invoker);
            }
            if (field != null) {
                try {
                    ReflectionUtils.makeAccessible(field);
                    value = field.get(target);
                    return new TypedValue(value, invoker.typeDescriptor.narrow(value));
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access field: " + name, ex);
                }
            }
        }
        throw new AccessException("Neither getter nor field found for property '" + name + "'");
    }

    @Override
    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        if (target == null) {
            return false;
        }
        Class<?> type = target instanceof Class ? (Class<?>)target : target.getClass();
        CacheKey cacheKey = new CacheKey(type, name);
        if (this.writerCache.containsKey(cacheKey)) {
            return true;
        }
        Method method = this.findSetterForProperty(name, type, target);
        if (method != null) {
            Property property = new Property(type, null, method);
            TypeDescriptor typeDescriptor = new TypeDescriptor(property);
            this.writerCache.put(cacheKey, method);
            this.typeDescriptorCache.put(cacheKey, typeDescriptor);
            return true;
        }
        Field field = this.findField(name, type, target);
        if (field != null) {
            this.writerCache.put(cacheKey, field);
            this.typeDescriptorCache.put(cacheKey, new TypeDescriptor(field));
            return true;
        }
        return false;
    }

    @Override
    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        CacheKey cacheKey;
        Member cachedMember;
        if (target == null) {
            throw new AccessException("Cannot write property on null target");
        }
        Class<?> type = target instanceof Class ? (Class<?>)target : target.getClass();
        Object possiblyConvertedNewValue = newValue;
        TypeDescriptor typeDescriptor = this.getTypeDescriptor(context, target, name);
        if (typeDescriptor != null) {
            try {
                possiblyConvertedNewValue = context.getTypeConverter().convertValue(newValue, TypeDescriptor.forObject(newValue), typeDescriptor);
            }
            catch (EvaluationException evaluationException) {
                throw new AccessException("Type conversion failure", evaluationException);
            }
        }
        if ((cachedMember = this.writerCache.get(cacheKey = new CacheKey(type, name))) == null || cachedMember instanceof Method) {
            Method method = (Method)cachedMember;
            if (method == null && (method = this.findSetterForProperty(name, type, target)) != null) {
                cachedMember = method;
                this.writerCache.put(cacheKey, cachedMember);
            }
            if (method != null) {
                try {
                    ReflectionUtils.makeAccessible(method);
                    method.invoke(target, possiblyConvertedNewValue);
                    return;
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access property '" + name + "' through setter", ex);
                }
            }
        }
        if (cachedMember == null || cachedMember instanceof Field) {
            Field field = (Field)cachedMember;
            if (field == null && (field = this.findField(name, type, target)) != null) {
                cachedMember = field;
                this.writerCache.put(cacheKey, cachedMember);
            }
            if (field != null) {
                try {
                    ReflectionUtils.makeAccessible(field);
                    field.set(target, possiblyConvertedNewValue);
                    return;
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access field: " + name, ex);
                }
            }
        }
        throw new AccessException("Neither setter nor field found for property '" + name + "'");
    }

    private TypeDescriptor getTypeDescriptor(EvaluationContext context, Object target, String name) {
        Class<?> type;
        if (target == null) {
            return null;
        }
        Class<?> clazz = type = target instanceof Class ? (Class<?>)target : target.getClass();
        if (type.isArray() && name.equals("length")) {
            return TypeDescriptor.valueOf(Integer.TYPE);
        }
        CacheKey cacheKey = new CacheKey(type, name);
        TypeDescriptor typeDescriptor = this.typeDescriptorCache.get(cacheKey);
        if (typeDescriptor == null) {
            try {
                if (this.canRead(context, target, name)) {
                    typeDescriptor = this.typeDescriptorCache.get(cacheKey);
                } else if (this.canWrite(context, target, name)) {
                    typeDescriptor = this.typeDescriptorCache.get(cacheKey);
                }
            }
            catch (AccessException ex) {
                // empty catch block
            }
        }
        return typeDescriptor;
    }

    private Method findGetterForProperty(String propertyName, Class<?> clazz, Object target) {
        Method method = this.findGetterForProperty(propertyName, clazz, target instanceof Class);
        if (method == null && target instanceof Class) {
            method = this.findGetterForProperty(propertyName, target.getClass(), false);
        }
        return method;
    }

    private Method findSetterForProperty(String propertyName, Class<?> clazz, Object target) {
        Method method = this.findSetterForProperty(propertyName, clazz, target instanceof Class);
        if (method == null && target instanceof Class) {
            method = this.findSetterForProperty(propertyName, target.getClass(), false);
        }
        return method;
    }

    private Field findField(String name, Class<?> clazz, Object target) {
        Field field = this.findField(name, clazz, target instanceof Class);
        if (field == null && target instanceof Class) {
            field = this.findField(name, target.getClass(), false);
        }
        return field;
    }

    protected Method findGetterForProperty(String propertyName, Class<?> clazz, boolean mustBeStatic) {
        Method[] ms = this.getSortedClassMethods(clazz);
        String propertyMethodSuffix = this.getPropertyMethodSuffix(propertyName);
        String getterName = "get" + propertyMethodSuffix;
        for (Method method : ms) {
            if (!method.getName().equals(getterName) || method.getParameterTypes().length != 0 || mustBeStatic && !Modifier.isStatic(method.getModifiers())) continue;
            return method;
        }
        getterName = "is" + propertyMethodSuffix;
        for (Method method : ms) {
            if (!method.getName().equals(getterName) || method.getParameterTypes().length != 0 || !Boolean.TYPE.equals(method.getReturnType()) && !Boolean.class.equals(method.getReturnType()) || mustBeStatic && !Modifier.isStatic(method.getModifiers())) continue;
            return method;
        }
        return null;
    }

    protected Method findSetterForProperty(String propertyName, Class<?> clazz, boolean mustBeStatic) {
        Method[] methods = this.getSortedClassMethods(clazz);
        String setterName = "set" + this.getPropertyMethodSuffix(propertyName);
        for (Method method : methods) {
            if (!method.getName().equals(setterName) || method.getParameterTypes().length != 1 || mustBeStatic && !Modifier.isStatic(method.getModifiers())) continue;
            return method;
        }
        return null;
    }

    private Method[] getSortedClassMethods(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.isBridge() == o2.isBridge() ? 0 : (o1.isBridge() ? 1 : -1);
            }
        });
        return methods;
    }

    protected String getPropertyMethodSuffix(String propertyName) {
        if (propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1))) {
            return propertyName;
        }
        return StringUtils.capitalize(propertyName);
    }

    protected Field findField(String name, Class<?> clazz, boolean mustBeStatic) {
        Field field;
        Field[] fields = clazz.getFields();
        for (Field field2 : fields) {
            if (!field2.getName().equals(name) || mustBeStatic && !Modifier.isStatic(field2.getModifiers())) continue;
            return field2;
        }
        if (clazz.getSuperclass() != null && (field = this.findField(name, clazz.getSuperclass(), mustBeStatic)) != null) {
            return field;
        }
        for (AnnotatedElement annotatedElement : clazz.getInterfaces()) {
            Field field3 = this.findField(name, (Class<?>)annotatedElement, mustBeStatic);
            if (field3 == null) continue;
            return field3;
        }
        return null;
    }

    public PropertyAccessor createOptimalAccessor(EvaluationContext eContext, Object target, String name) {
        Class<?> type;
        if (target == null) {
            return this;
        }
        Class<?> clazz = type = target instanceof Class ? (Class<?>)target : target.getClass();
        if (type.isArray()) {
            return this;
        }
        CacheKey cacheKey = new CacheKey(type, name);
        InvokerPair invocationTarget = this.readerCache.get(cacheKey);
        if (invocationTarget == null || invocationTarget.member instanceof Method) {
            Method method = (Method)(invocationTarget == null ? null : invocationTarget.member);
            if (method == null && (method = this.findGetterForProperty(name, type, target)) != null) {
                invocationTarget = new InvokerPair(method, new TypeDescriptor(new MethodParameter(method, -1)));
                ReflectionUtils.makeAccessible(method);
                this.readerCache.put(cacheKey, invocationTarget);
            }
            if (method != null) {
                return new OptimalPropertyAccessor(invocationTarget);
            }
        }
        if (invocationTarget == null || invocationTarget.member instanceof Field) {
            Field field = (Field)(invocationTarget == null ? null : invocationTarget.member);
            if (field == null && (field = this.findField(name, type, target instanceof Class)) != null) {
                invocationTarget = new InvokerPair(field, new TypeDescriptor(field));
                ReflectionUtils.makeAccessible(field);
                this.readerCache.put(cacheKey, invocationTarget);
            }
            if (field != null) {
                return new OptimalPropertyAccessor(invocationTarget);
            }
        }
        return this;
    }

    private static class OptimalPropertyAccessor
    implements PropertyAccessor {
        private final Member member;
        private final TypeDescriptor typeDescriptor;
        private final boolean needsToBeMadeAccessible;

        OptimalPropertyAccessor(InvokerPair target) {
            Method method;
            Field field;
            this.member = target.member;
            this.typeDescriptor = target.typeDescriptor;
            this.needsToBeMadeAccessible = this.member instanceof Field ? (!Modifier.isPublic((field = (Field)this.member).getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) && !field.isAccessible() : (!Modifier.isPublic((method = (Method)this.member).getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) && !method.isAccessible();
        }

        public Class[] getSpecificTargetClasses() {
            throw new UnsupportedOperationException("Should not be called on an OptimalPropertyAccessor");
        }

        public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
            Class<?> type;
            if (target == null) {
                return false;
            }
            Class<?> clazz = type = target instanceof Class ? (Class<?>)target : target.getClass();
            if (type.isArray()) {
                return false;
            }
            if (this.member instanceof Method) {
                Method method = (Method)this.member;
                String getterName = "get" + StringUtils.capitalize(name);
                if (getterName.equals(method.getName())) {
                    return true;
                }
                getterName = "is" + StringUtils.capitalize(name);
                return getterName.equals(method.getName());
            }
            Field field = (Field)this.member;
            return field.getName().equals(name);
        }

        public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
            if (this.member instanceof Method) {
                try {
                    if (this.needsToBeMadeAccessible) {
                        ReflectionUtils.makeAccessible((Method)this.member);
                    }
                    Object value = ((Method)this.member).invoke(target, new Object[0]);
                    return new TypedValue(value, this.typeDescriptor.narrow(value));
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access property '" + name + "' through getter", ex);
                }
            }
            if (this.member instanceof Field) {
                try {
                    if (this.needsToBeMadeAccessible) {
                        ReflectionUtils.makeAccessible((Field)this.member);
                    }
                    Object value = ((Field)this.member).get(target);
                    return new TypedValue(value, this.typeDescriptor.narrow(value));
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access field: " + name, ex);
                }
            }
            throw new AccessException("Neither getter nor field found for property '" + name + "'");
        }

        public boolean canWrite(EvaluationContext context, Object target, String name) {
            throw new UnsupportedOperationException("Should not be called on an OptimalPropertyAccessor");
        }

        public void write(EvaluationContext context, Object target, String name, Object newValue) {
            throw new UnsupportedOperationException("Should not be called on an OptimalPropertyAccessor");
        }
    }

    private static class CacheKey {
        private final Class clazz;
        private final String name;

        public CacheKey(Class clazz, String name) {
            this.clazz = clazz;
            this.name = name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey otherKey = (CacheKey)other;
            return this.clazz.equals(otherKey.clazz) && this.name.equals(otherKey.name);
        }

        public int hashCode() {
            return this.clazz.hashCode() * 29 + this.name.hashCode();
        }
    }

    private static class InvokerPair {
        final Member member;
        final TypeDescriptor typeDescriptor;

        public InvokerPair(Member member, TypeDescriptor typeDescriptor) {
            this.member = member;
            this.typeDescriptor = typeDescriptor;
        }
    }
}

