/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.module;

import com.beust.jcommander.JCommander;
import com.ncloud.api.cli.common.model.CommandEnum;
import com.ncloud.api.cli.common.model.CommandOption;
import com.ncloud.api.cli.common.options.GlobalOptions;
import com.ncloud.api.cli.common.util.CliCallUtil;
import com.ncloud.api.cli.common.util.CommandUtil;
import com.ncloud.api.cli.common.util.GlobalOptionUtil;
import com.ncloud.api.cli.exception.NcloudCliException;
import com.ncloud.api.cli.vpc.options.AcceptOrRejectVpcPeeringOptions;
import com.ncloud.api.cli.vpc.options.AddNetworkAclInboundRuleOptions;
import com.ncloud.api.cli.vpc.options.AddNetworkAclOutboundRuleOptions;
import com.ncloud.api.cli.vpc.options.AddRouteOptions;
import com.ncloud.api.cli.vpc.options.AddRouteTableSubnetOptions;
import com.ncloud.api.cli.vpc.options.CreateNatGatewayInstanceOptions;
import com.ncloud.api.cli.vpc.options.CreateNetworkAclDenyAllowGroupOptions;
import com.ncloud.api.cli.vpc.options.CreateNetworkAclOptions;
import com.ncloud.api.cli.vpc.options.CreateRouteTableOptions;
import com.ncloud.api.cli.vpc.options.CreateSubnetOptions;
import com.ncloud.api.cli.vpc.options.CreateVpcOptions;
import com.ncloud.api.cli.vpc.options.CreateVpcPeeringInstanceOptions;
import com.ncloud.api.cli.vpc.options.DeleteNatGatewayInstanceOptions;
import com.ncloud.api.cli.vpc.options.DeleteNetworkAclDenyAllowGroupOptions;
import com.ncloud.api.cli.vpc.options.DeleteNetworkAclOptions;
import com.ncloud.api.cli.vpc.options.DeleteRouteTableOptions;
import com.ncloud.api.cli.vpc.options.DeleteSubnetOptions;
import com.ncloud.api.cli.vpc.options.DeleteVpcOptions;
import com.ncloud.api.cli.vpc.options.DeleteVpcPeeringInstanceOptions;
import com.ncloud.api.cli.vpc.options.GetNatGatewayInstanceDetailOptions;
import com.ncloud.api.cli.vpc.options.GetNatGatewayInstanceListOptions;
import com.ncloud.api.cli.vpc.options.GetNetworkAclDenyAllowGroupDetailOptions;
import com.ncloud.api.cli.vpc.options.GetNetworkAclDenyAllowGroupListOptions;
import com.ncloud.api.cli.vpc.options.GetNetworkAclDetailOptions;
import com.ncloud.api.cli.vpc.options.GetNetworkAclListOptions;
import com.ncloud.api.cli.vpc.options.GetNetworkAclRuleListOptions;
import com.ncloud.api.cli.vpc.options.GetRouteListOptions;
import com.ncloud.api.cli.vpc.options.GetRouteTableDetailOptions;
import com.ncloud.api.cli.vpc.options.GetRouteTableListOptions;
import com.ncloud.api.cli.vpc.options.GetRouteTableSubnetListOptions;
import com.ncloud.api.cli.vpc.options.GetSubnetDetailOptions;
import com.ncloud.api.cli.vpc.options.GetSubnetListOptions;
import com.ncloud.api.cli.vpc.options.GetVpcDetailOptions;
import com.ncloud.api.cli.vpc.options.GetVpcListOptions;
import com.ncloud.api.cli.vpc.options.GetVpcPeeringInstanceDetailOptions;
import com.ncloud.api.cli.vpc.options.GetVpcPeeringInstanceListOptions;
import com.ncloud.api.cli.vpc.options.RemoveNetworkAclInboundRuleOptions;
import com.ncloud.api.cli.vpc.options.RemoveNetworkAclOutboundRuleOptions;
import com.ncloud.api.cli.vpc.options.RemoveRouteOptions;
import com.ncloud.api.cli.vpc.options.RemoveRouteTableSubnetOptions;
import com.ncloud.api.cli.vpc.options.SetNatGatewayDescriptionOptions;
import com.ncloud.api.cli.vpc.options.SetNetworkAclDenyAllowGroupDescriptionOptions;
import com.ncloud.api.cli.vpc.options.SetNetworkAclDenyAllowGroupIpListOptions;
import com.ncloud.api.cli.vpc.options.SetNetworkAclDescriptionOptions;
import com.ncloud.api.cli.vpc.options.SetRouteTableDescriptionOptions;
import com.ncloud.api.cli.vpc.options.SetSubnetNetworkAclOptions;
import com.ncloud.api.cli.vpc.options.SetVpcPeeringDescriptionOptions;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vpc {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void execute(JCommander vpcCommander, CommandEnum.VpcCommand vpcCommand) throws NcloudCliException, UnsupportedEncodingException {
        JCommander subCommander = vpcCommander.getCommands().get(vpcCommand.getCode());
        CommandOption commandOption = null;
        String requestUri = null;
        switch (vpcCommand) {
            case getVpcList: {
                requestUri = "/vpc/v2/getVpcList";
                commandOption = (GetVpcListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getVpcDetail: {
                requestUri = "/vpc/v2/getVpcDetail";
                commandOption = (GetVpcDetailOptions)subCommander.getObjects().get(0);
                break;
            }
            case createVpc: {
                requestUri = "/vpc/v2/createVpc";
                commandOption = (CreateVpcOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteVpc: {
                requestUri = "/vpc/v2/deleteVpc";
                commandOption = (DeleteVpcOptions)subCommander.getObjects().get(0);
                break;
            }
            case getNetworkAclList: {
                requestUri = "/vpc/v2/getNetworkAclList";
                commandOption = (GetNetworkAclListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getNetworkAclDetail: {
                requestUri = "/vpc/v2/getNetworkAclDetail";
                commandOption = (GetNetworkAclDetailOptions)subCommander.getObjects().get(0);
                break;
            }
            case createNetworkAcl: {
                requestUri = "/vpc/v2/createNetworkAcl";
                commandOption = (CreateNetworkAclOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteNetworkAcl: {
                requestUri = "/vpc/v2/deleteNetworkAcl";
                commandOption = (DeleteNetworkAclOptions)subCommander.getObjects().get(0);
                break;
            }
            case setSubnetNetworkAcl: {
                requestUri = "/vpc/v2/setSubnetNetworkAcl";
                commandOption = (SetSubnetNetworkAclOptions)subCommander.getObjects().get(0);
                break;
            }
            case getNetworkAclRuleList: {
                requestUri = "/vpc/v2/getNetworkAclRuleList";
                commandOption = (GetNetworkAclRuleListOptions)subCommander.getObjects().get(0);
                break;
            }
            case addNetworkAclInboundRule: {
                requestUri = "/vpc/v2/addNetworkAclInboundRule";
                commandOption = (AddNetworkAclInboundRuleOptions)subCommander.getObjects().get(0);
                break;
            }
            case addNetworkAclOutboundRule: {
                requestUri = "/vpc/v2/addNetworkAclOutboundRule";
                commandOption = (AddNetworkAclOutboundRuleOptions)subCommander.getObjects().get(0);
                break;
            }
            case removeNetworkAclInboundRule: {
                requestUri = "/vpc/v2/removeNetworkAclInboundRule";
                commandOption = (RemoveNetworkAclInboundRuleOptions)subCommander.getObjects().get(0);
                break;
            }
            case removeNetworkAclOutboundRule: {
                requestUri = "/vpc/v2/removeNetworkAclOutboundRule";
                commandOption = (RemoveNetworkAclOutboundRuleOptions)subCommander.getObjects().get(0);
                break;
            }
            case getNetworkAclDenyAllowGroupList: {
                requestUri = "/vpc/v2/getNetworkAclDenyAllowGroupList";
                commandOption = (GetNetworkAclDenyAllowGroupListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getNetworkAclDenyAllowGroupDetail: {
                requestUri = "/vpc/v2/getNetworkAclDenyAllowGroupDetail";
                commandOption = (GetNetworkAclDenyAllowGroupDetailOptions)subCommander.getObjects().get(0);
                break;
            }
            case createNetworkAclDenyAllowGroup: {
                requestUri = "/vpc/v2/createNetworkAclDenyAllowGroup";
                commandOption = (CreateNetworkAclDenyAllowGroupOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteNetworkAclDenyAllowGroup: {
                requestUri = "/vpc/v2/deleteNetworkAclDenyAllowGroup";
                commandOption = (DeleteNetworkAclDenyAllowGroupOptions)subCommander.getObjects().get(0);
                break;
            }
            case setNetworkAclDenyAllowGroupIpList: {
                requestUri = "/vpc/v2/setNetworkAclDenyAllowGroupIpList";
                commandOption = (SetNetworkAclDenyAllowGroupIpListOptions)subCommander.getObjects().get(0);
                break;
            }
            case setNetworkAclDenyAllowGroupDescription: {
                requestUri = "/vpc/v2/setNetworkAclDenyAllowGroupDescription";
                commandOption = (SetNetworkAclDenyAllowGroupDescriptionOptions)subCommander.getObjects().get(0);
                break;
            }
            case getSubnetList: {
                requestUri = "/vpc/v2/getSubnetList";
                commandOption = (GetSubnetListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getSubnetDetail: {
                requestUri = "/vpc/v2/getSubnetDetail";
                commandOption = (GetSubnetDetailOptions)subCommander.getObjects().get(0);
                break;
            }
            case createSubnet: {
                requestUri = "/vpc/v2/createSubnet";
                commandOption = (CreateSubnetOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteSubnet: {
                requestUri = "/vpc/v2/deleteSubnet";
                commandOption = (DeleteSubnetOptions)subCommander.getObjects().get(0);
                break;
            }
            case getVpcPeeringInstanceList: {
                requestUri = "/vpc/v2/getVpcPeeringInstanceList";
                commandOption = (GetVpcPeeringInstanceListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getVpcPeeringInstanceDetail: {
                requestUri = "/vpc/v2/getVpcPeeringInstanceDetail";
                commandOption = (GetVpcPeeringInstanceDetailOptions)subCommander.getObjects().get(0);
                break;
            }
            case createVpcPeeringInstance: {
                requestUri = "/vpc/v2/createVpcPeeringInstance";
                commandOption = (CreateVpcPeeringInstanceOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteVpcPeeringInstance: {
                requestUri = "/vpc/v2/deleteVpcPeeringInstance";
                commandOption = (DeleteVpcPeeringInstanceOptions)subCommander.getObjects().get(0);
                break;
            }
            case acceptOrRejectVpcPeering: {
                requestUri = "/vpc/v2/acceptOrRejectVpcPeering";
                commandOption = (AcceptOrRejectVpcPeeringOptions)subCommander.getObjects().get(0);
                break;
            }
            case getNatGatewayInstanceList: {
                requestUri = "/vpc/v2/getNatGatewayInstanceList";
                commandOption = (GetNatGatewayInstanceListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getNatGatewayInstanceDetail: {
                requestUri = "/vpc/v2/getNatGatewayInstanceDetail";
                commandOption = (GetNatGatewayInstanceDetailOptions)subCommander.getObjects().get(0);
                break;
            }
            case createNatGatewayInstance: {
                requestUri = "/vpc/v2/createNatGatewayInstance";
                commandOption = (CreateNatGatewayInstanceOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteNatGatewayInstance: {
                requestUri = "/vpc/v2/deleteNatGatewayInstance";
                commandOption = (DeleteNatGatewayInstanceOptions)subCommander.getObjects().get(0);
                break;
            }
            case getRouteTableList: {
                requestUri = "/vpc/v2/getRouteTableList";
                commandOption = (GetRouteTableListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getRouteTableDetail: {
                requestUri = "/vpc/v2/getRouteTableDetail";
                commandOption = (GetRouteTableDetailOptions)subCommander.getObjects().get(0);
                break;
            }
            case createRouteTable: {
                requestUri = "/vpc/v2/createRouteTable";
                commandOption = (CreateRouteTableOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteRouteTable: {
                requestUri = "/vpc/v2/deleteRouteTable";
                commandOption = (DeleteRouteTableOptions)subCommander.getObjects().get(0);
                break;
            }
            case getRouteList: {
                requestUri = "/vpc/v2/getRouteList";
                commandOption = (GetRouteListOptions)subCommander.getObjects().get(0);
                break;
            }
            case addRoute: {
                requestUri = "/vpc/v2/addRoute";
                commandOption = (AddRouteOptions)subCommander.getObjects().get(0);
                break;
            }
            case removeRoute: {
                requestUri = "/vpc/v2/removeRoute";
                commandOption = (RemoveRouteOptions)subCommander.getObjects().get(0);
                break;
            }
            case getRouteTableSubnetList: {
                requestUri = "/vpc/v2/getRouteTableSubnetList";
                commandOption = (GetRouteTableSubnetListOptions)subCommander.getObjects().get(0);
                break;
            }
            case addRouteTableSubnet: {
                requestUri = "/vpc/v2/addRouteTableSubnet";
                commandOption = (AddRouteTableSubnetOptions)subCommander.getObjects().get(0);
                break;
            }
            case removeRouteTableSubnet: {
                requestUri = "/vpc/v2/removeRouteTableSubnet";
                commandOption = (RemoveRouteTableSubnetOptions)subCommander.getObjects().get(0);
                break;
            }
            case setNatGatewayDescription: {
                requestUri = "/vpc/v2/setNatGatewayDescription";
                commandOption = (SetNatGatewayDescriptionOptions)subCommander.getObjects().get(0);
                break;
            }
            case setNetworkAclDescription: {
                requestUri = "/vpc/v2/setNetworkAclDescription";
                commandOption = (SetNetworkAclDescriptionOptions)subCommander.getObjects().get(0);
                break;
            }
            case setRouteTableDescription: {
                requestUri = "/vpc/v2/setRouteTableDescription";
                commandOption = (SetRouteTableDescriptionOptions)subCommander.getObjects().get(0);
                break;
            }
            case setVpcPeeringDescription: {
                requestUri = "/vpc/v2/setVpcPeeringDescription";
                commandOption = (SetVpcPeeringDescriptionOptions)subCommander.getObjects().get(0);
                break;
            }
        }
        if (null != requestUri) {
            GlobalOptions globalOptions = commandOption.getCommandOptions().getGlobalOptions();
            String profile = globalOptions.getProfile();
            boolean isDebug = GlobalOptionUtil.getIsDebug();
            if (profile == null) {
                profile = "DEFAULT";
            }
            CliCallUtil.call(globalOptions, CommandUtil.getNcloudNewApiRequest(profile, isDebug), requestUri, commandOption);
        }
    }
}

