/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.converter;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ncloud.api.cli.common.util.HttpConnectionUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapParseConverter
implements IStringConverter<Map<String, Object>> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Map<String, Object> convert(String rowString) {
        if (org.springframework.util.StringUtils.isEmpty(rowString)) {
            throw new ParameterException("Please check your input value. You have entered a blank string.");
        }
        Gson gson = new Gson();
        String jsonString = "{" + rowString.replace("=", ":") + "}";
        Map parsedMap = null;
        try {
            parsedMap = (Map)gson.fromJson(jsonString, new TypeToken<Map<String, Object>>(){}.getType());
            this.executeMapString(parsedMap);
        }
        catch (NoSuchFileException e) {
            throw new ParameterException("Please check your input value. Can't read below file.\n" + e.getFile());
        }
        catch (Exception e) {
            throw new ParameterException("Please check your input value. You have entered wrong parameters.");
        }
        return parsedMap;
    }

    private String executeMapString(Object node) throws NoSuchFileException {
        if (node instanceof String) {
            String nodeString = (String)node;
            if (org.springframework.util.StringUtils.startsWithIgnoreCase(nodeString, "file://")) {
                try {
                    this.logger.info("Found FilePrefix, read content from " + nodeString);
                    StringBuffer result = this.getFileContent(nodeString);
                    this.logger.info("read contents ---> " + result.toString());
                    return result.toString();
                }
                catch (Exception e) {
                    this.logger.debug("errors occurred while reading file : " + nodeString);
                    throw new NoSuchFileException(nodeString);
                }
            }
            if (org.springframework.util.StringUtils.startsWithIgnoreCase(nodeString, "http://") || org.springframework.util.StringUtils.startsWithIgnoreCase(nodeString, "https://")) {
                try {
                    this.logger.info("Found HttpPrefix, read content from " + nodeString);
                    StringBuffer result = this.getHttpContent(nodeString);
                    this.logger.info("read contents ---> " + result.toString());
                    return result.toString();
                }
                catch (Exception e) {
                    this.logger.debug("errors occurred while reading page : " + nodeString);
                    throw new NoSuchFileException(nodeString);
                }
            }
        }
        try {
            if (node instanceof Map) {
                Map nodeMap = (Map)node;
                for (String key : nodeMap.keySet()) {
                    String result = this.executeMapString(nodeMap.get(key));
                    if (result == null) continue;
                    nodeMap.put(key, result);
                }
            }
            if (node instanceof List) {
                List nodeList = (List)node;
                for (Object item : nodeList) {
                    this.executeMapString(item);
                }
            }
        }
        catch (NoSuchFileException e) {
            this.logger.debug(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.logger.debug("errors occurred while parsing parameter.");
            return null;
        }
        return null;
    }

    private StringBuffer getHttpContent(String resourcePath) {
        StringBuffer resourceContent = new StringBuffer();
        HttpConnectionUtil httpConnectionUtil = new HttpConnectionUtil();
        try {
            resourceContent.append(httpConnectionUtil.getConnect(resourcePath, "UTF-8"));
        }
        catch (Exception e) {
            this.logger.error("", e);
            throw new ParameterException(e.getMessage());
        }
        return resourceContent;
    }

    private StringBuffer getFileContent(String resourcePath) {
        StringBuffer resourceContent = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(StringUtils.substringAfterLast(resourcePath, "file://")));
            boolean firstLine = true;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!firstLine) {
                    resourceContent.append("\n");
                }
                resourceContent.append(line);
                firstLine = false;
            }
        }
        catch (Exception e) {
            this.logger.debug("", e);
            throw new ParameterException(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return resourceContent;
    }
}

