/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.module;

import com.beust.jcommander.JCommander;
import com.ncloud.api.cli.cdn.options.GetCdnPlusInstanceListOptions;
import com.ncloud.api.cli.cdn.options.GetCdnPlusPurgeHistoryListOptions;
import com.ncloud.api.cli.cdn.options.RequestCdnPlusPurgeOptions;
import com.ncloud.api.cli.common.model.CommandEnum;
import com.ncloud.api.cli.common.model.CommandOption;
import com.ncloud.api.cli.common.options.GlobalOptions;
import com.ncloud.api.cli.common.util.CliCallUtil;
import com.ncloud.api.cli.common.util.CommandUtil;
import com.ncloud.api.cli.common.util.GlobalOptionUtil;
import com.ncloud.api.cli.exception.NcloudCliException;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cdn {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void execute(JCommander cdnCommander, CommandEnum.CdnCommand cdnCommand) throws NcloudCliException, UnsupportedEncodingException {
        JCommander subCommander = cdnCommander.getCommands().get(cdnCommand.getCode());
        CommandOption commandOption = null;
        String requestUri = null;
        switch (cdnCommand) {
            case getCdnPlusInstanceList: {
                requestUri = "/cdn/v2/getCdnPlusInstanceList";
                commandOption = (GetCdnPlusInstanceListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getCdnPlusPurgeHistoryList: {
                requestUri = "/cdn/v2/getCdnPlusPurgeHistoryList";
                commandOption = (GetCdnPlusPurgeHistoryListOptions)subCommander.getObjects().get(0);
                break;
            }
            case requestCdnPlusPurge: {
                requestUri = "/cdn/v2/requestCdnPlusPurge";
                commandOption = (RequestCdnPlusPurgeOptions)subCommander.getObjects().get(0);
                break;
            }
        }
        if (null != requestUri) {
            GlobalOptions globalOptions = commandOption.getCommandOptions().getGlobalOptions();
            String profile = globalOptions.getProfile();
            boolean isDebug = GlobalOptionUtil.getIsDebug();
            if (profile == null) {
                profile = "DEFAULT";
            }
            CliCallUtil.call(globalOptions, CommandUtil.getNcloudNewApiRequest(profile, isDebug), requestUri, commandOption);
        }
    }
}

