/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.module;

import com.beust.jcommander.JCommander;
import com.ncloud.api.cli.common.model.CommandEnum;
import com.ncloud.api.cli.common.model.EnvironmentEnum;
import com.ncloud.api.cli.common.options.GlobalOptions;
import com.ncloud.api.cli.common.options.HelpOptions;
import com.ncloud.api.cli.common.util.CommandUtil;
import com.ncloud.api.cli.common.util.EnvironmentUtil;
import com.ncloud.api.cli.exception.NcloudCliException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Help {
    private static Logger logger = LoggerFactory.getLogger(Help.class);
    private static final String HELP_EXCEPTION_MESSAGE_KEY = "${Exception.Message}";

    public static String getHelpCommand(JCommander ncloudCommander) {
        String help = null;
        try {
            JCommander helpCommander;
            GlobalOptions globalOptions = (GlobalOptions)ncloudCommander.getObjects().get(0);
            if (globalOptions.isVersion()) {
                return null;
            }
            if (StringUtils.isEmpty(ncloudCommander.getParsedCommand())) {
                throw new NcloudCliException("The command does not exist. For help, input 'help' command.");
            }
            String environment = "";
            if (EnvironmentUtil.isPubEnvironment()) {
                environment = EnvironmentEnum.Kind.PUB.getCode();
            } else if (EnvironmentUtil.isGovEnvironment()) {
                environment = EnvironmentEnum.Kind.GOV.getCode();
            } else if (EnvironmentUtil.isFinEnvironment()) {
                environment = EnvironmentEnum.Kind.FIN.getCode();
            }
            CommandEnum.Command command = CommandEnum.Command.fromCode(ncloudCommander.getParsedCommand());
            if (command == CommandEnum.Command.help && (helpCommander = ncloudCommander.getCommands().get(command.getCode())) != null && helpCommander.getObjects().size() == 1) {
                HelpOptions helpOptions = (HelpOptions)helpCommander.getObjects().get(0);
                String language = helpOptions.getLanguage();
                String fileName = "command.help";
                String filePathName = "/help/" + environment + "/" + language + "/common/" + fileName;
                logger.debug("filePathName->" + filePathName);
                help = Help.getLoadResource(filePathName);
                return help;
            }
            JCommander mainCommander = ncloudCommander.getCommands().get(command.getCode());
            if (mainCommander != null) {
                JCommander helpCommander2;
                JCommander helpCommander3;
                if ("help".equals(mainCommander.getParsedCommand()) && (helpCommander3 = mainCommander.getCommands().get("help")) != null && helpCommander3.getObjects().size() == 1) {
                    HelpOptions helpOptions = (HelpOptions)helpCommander3.getObjects().get(0);
                    String language = helpOptions.getLanguage();
                    String filePathName = "/help/" + environment + "/" + language + "/" + command.getCode() + "/" + command.getCode() + ".help";
                    logger.debug("filePathName->" + filePathName);
                    help = Help.getLoadResource(filePathName);
                    return help;
                }
                JCommander subCommander = mainCommander.getCommands().get(mainCommander.getParsedCommand());
                if (subCommander != null && "help".equals(subCommander.getParsedCommand()) && (helpCommander2 = subCommander.getCommands().get("help")) != null && subCommander.getObjects().size() == 1) {
                    HelpOptions helpOptions = (HelpOptions)helpCommander2.getObjects().get(0);
                    String language = helpOptions.getLanguage();
                    String filePathName = "/help/" + environment + "/" + language + "/" + command.getCode() + "/" + mainCommander.getParsedCommand() + ".help";
                    logger.debug("filePathName->" + filePathName);
                    help = Help.getLoadResource(filePathName);
                    return help;
                }
            }
        }
        catch (NcloudCliException e) {
            logger.debug("", e);
            help = Help.getHelpExceptionMessage(e);
        }
        catch (NullPointerException e) {
            logger.debug("", e);
            help = Help.getHelpExceptionMessage(e);
        }
        return help;
    }

    public static String getHelpExceptionMessage(Exception exception) {
        String filePathName = "/help/pub/exception/exception.help";
        String help = null;
        try {
            help = Help.getLoadResource(filePathName);
            help = StringUtils.isNotEmpty(exception.getMessage()) ? StringUtils.replace(help.toString(), HELP_EXCEPTION_MESSAGE_KEY, "\nncloud: error: " + exception.getMessage() + "\n") : StringUtils.replace(help.toString(), HELP_EXCEPTION_MESSAGE_KEY, "");
        }
        catch (NcloudCliException ignore) {
            logger.error("", ignore);
        }
        return help;
    }

    private static String getLoadResource(String filePathName) throws NcloudCliException {
        InputStream is = CommandUtil.class.getResourceAsStream(filePathName);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            logger.error("", e1);
        }
        StringBuffer buf = new StringBuffer();
        try {
            String readString;
            while (null != (readString = br.readLine())) {
                buf.append(readString).append("\n");
            }
        }
        catch (IOException e) {
            logger.error("", e);
            throw new NcloudCliException(e);
        }
        return buf.toString();
    }
}

