/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.main;

import com.beust.jcommander.JCommander;
import com.ncloud.api.cli.common.model.Constant;
import com.ncloud.api.cli.common.options.GlobalOptions;
import com.ncloud.api.cli.common.util.CommandUtil;
import com.ncloud.api.cli.common.util.ConfigureUtil;
import com.ncloud.api.cli.common.util.GlobalOptionUtil;
import com.ncloud.api.cli.module.Help;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ncloud {
    private static Logger logger = LoggerFactory.getLogger(Ncloud.class);

    public static void main(String[] arguments) {
        JCommander ncloudCommander = CommandUtil.loadNcloudCommander();
        try {
            ncloudCommander.parse(arguments);
            Ncloud.getHelpCommand(ncloudCommander, 0);
        }
        catch (Exception e) {
            Ncloud.getHelpCommand(ncloudCommander, 1);
            Ncloud.getHelpExceptionMessage(e);
        }
        GlobalOptions globalOptions = (GlobalOptions)ncloudCommander.getObjects().get(0);
        Ncloud.getVersion(globalOptions);
        GlobalOptionUtil.init(globalOptions);
        int configurationCount = 0;
        try {
            configurationCount = ConfigureUtil.loadProfileConfigureList();
        }
        catch (IOException e) {
            logger.error("", e);
        }
        if (GlobalOptionUtil.getIsDebug().booleanValue()) {
            logger.info("Ncloud commands. Loading...");
            logger.info(CommandUtil.printCommands(ncloudCommander).toString());
        }
        if (GlobalOptionUtil.getIsDebug().booleanValue()) {
            logger.info("command execute start.");
        }
        if (configurationCount == 0 && arguments.length > 0 && !StringUtils.equals(arguments[0], "configure")) {
            System.out.println("credentials are not set yet. You can configure credentials by running \"ncloud configure\".");
            System.exit(1);
        }
        try {
            CommandUtil.executeCommand(ncloudCommander);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        if (GlobalOptionUtil.getIsDebug().booleanValue()) {
            logger.info("command execute end.");
        }
    }

    private static void getVersion(GlobalOptions globalOptions) {
        if (globalOptions.isVersion()) {
            StringBuffer version = new StringBuffer();
            version.append(Constant.NCLOUD_CLI_VERSION).append(" ").append("Java").append("/").append(System.getProperty("java.version")).append("\n").append(Constant.NCLOUD_CLI_NAME);
            System.out.println(version.toString());
            System.exit(0);
        }
    }

    private static void getHelpExceptionMessage(Exception e) {
        String exceptionMessage = Help.getHelpExceptionMessage(e);
        System.out.println(exceptionMessage);
        System.exit(1);
    }

    private static void getHelpCommand(JCommander ncloudCommander, int status) {
        String help = Help.getHelpCommand(ncloudCommander);
        if (StringUtils.isNotEmpty(help)) {
            System.out.println(help);
            System.exit(status);
        }
    }
}

