/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.common.util;

import com.ncloud.api.cli.common.model.Constant;
import com.ncloud.api.cli.common.util.GlobalOptionUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public final class HttpConnectionUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpConnectionUtil.class);
    public int httpConnectionTimeout = 5000;

    public HttpConnectionUtil() {
    }

    public HttpConnectionUtil(int httpConnectionTimeout) {
        this.httpConnectionTimeout = httpConnectionTimeout;
    }

    public String postConnect(String requestURI, Map<String, Object> parameters, String encoding) throws IOException {
        String returnStr;
        block6: {
            HttpURLConnection con = null;
            URL url = null;
            returnStr = null;
            BufferedOutputStream os = null;
            try {
                url = new URL(requestURI);
                con = (HttpURLConnection)url.openConnection();
                con.setDoInput(true);
                con.setDoOutput(true);
                con.setUseCaches(false);
                con.setAllowUserInteraction(false);
                con.setConnectTimeout(this.httpConnectionTimeout);
                con.setRequestProperty("User-Agent", Constant.NCLOUD_CLI_VERSION);
                con.setRequestMethod("POST");
                String postParameter = HttpConnectionUtil.getPostParameter(parameters, encoding, null);
                logger.debug("requestURI=>" + requestURI);
                logger.debug("postParameter=>" + postParameter);
                os = new BufferedOutputStream(con.getOutputStream());
                os.write(postParameter.getBytes(encoding));
                os.flush();
                int responseCode = con.getResponseCode();
                logger.debug("responseCode => " + responseCode);
                if (responseCode == 200) {
                    returnStr = this.read(con, encoding);
                    break block6;
                }
                throw new RuntimeException("request : " + requestURI + ", parameters : " + postParameter + ", reponseCode : " + responseCode);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                con.disconnect();
            }
        }
        logger.debug("returnStr=>" + returnStr);
        return returnStr;
    }

    public String getConnect(String requestURI, String encoding) throws IOException {
        String returnStr;
        block6: {
            HttpURLConnection con = null;
            URL url = null;
            returnStr = null;
            try {
                url = new URL(requestURI);
                con = (HttpURLConnection)url.openConnection();
                con.setRequestProperty("User-Agent", Constant.NCLOUD_CLI_VERSION);
                con.setRequestMethod("GET");
                con.setConnectTimeout(this.httpConnectionTimeout);
                int responseCode = con.getResponseCode();
                logger.debug("responseCode => " + responseCode);
                if (responseCode == 200) {
                    returnStr = this.read(con, encoding);
                    break block6;
                }
                throw new RuntimeException("request : " + requestURI + ", reponseCode : " + responseCode);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                con.disconnect();
            }
        }
        logger.debug("returnStr=>" + returnStr);
        return returnStr;
    }

    public static String restCall(URI uri, String method, HttpHeaders headers, Map<String, Object> params, Boolean isDebug, Integer connectionTimeout, Integer readTimeout) throws UnsupportedEncodingException {
        ResponseEntity<String> responseEntity;
        block8: {
            HttpComponentsClientHttpRequestFactory clientRequestFactory = new HttpComponentsClientHttpRequestFactory();
            Integer doConnectionTimeout = connectionTimeout != null ? connectionTimeout : GlobalOptionUtil.getConnectTimeout();
            Integer doReadTimeout = readTimeout != null ? readTimeout : GlobalOptionUtil.getReadTimeout();
            clientRequestFactory.setReadTimeout(doReadTimeout * 1000);
            clientRequestFactory.setConnectTimeout(doConnectionTimeout * 1000);
            RestTemplate restTemplate = new RestTemplate(clientRequestFactory);
            responseEntity = null;
            String queryString = HttpConnectionUtil.getPostParameter(params, "UTF-8", isDebug);
            headers.set("Content-Type", "application/x-www-form-urlencoded");
            HttpEntity<String> entity = new HttpEntity<String>(queryString, headers);
            if (isDebug.booleanValue()) {
                logger.info("uri-> " + uri);
                logger.info("method-> " + method);
                logger.info("headers-> " + headers);
            }
            try {
                responseEntity = restTemplate.exchange(uri, HttpConnectionUtil.getHttpMethod(method), entity, String.class);
            }
            catch (HttpStatusCodeException e) {
                if (e.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                    return "Invalid consumerKey";
                }
                if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                    return "Not found method";
                }
                return e.getResponseBodyAsString();
            }
            catch (ResourceAccessException e) {
                if (e.getCause() instanceof ConnectTimeoutException) {
                    return "Connection timeout occured.";
                }
                if (e.getCause() instanceof SocketTimeoutException) {
                    return "Read timeout occured.";
                }
                if (!(e.getCause() instanceof InterruptedException)) break block8;
                return "Interrupt occured.";
            }
        }
        return (String)responseEntity.getBody();
    }

    public static String restCall(URI uri, String method, HttpHeaders headers, Map<String, Object> params, Boolean isDebug) throws UnsupportedEncodingException {
        return HttpConnectionUtil.restCall(uri, method, headers, params, isDebug, null, null);
    }

    private static HttpMethod getHttpMethod(String method) {
        if ("POST".equals(method)) {
            return HttpMethod.POST;
        }
        if ("GET".equals(method)) {
            return HttpMethod.GET;
        }
        if ("PUT".equals(method)) {
            return HttpMethod.PUT;
        }
        if ("DELETE".equals(method)) {
            return HttpMethod.DELETE;
        }
        return null;
    }

    private String read(HttpURLConnection connection, String encoding) throws IOException {
        BufferedReader resultReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), encoding));
        StringBuffer buf = new StringBuffer();
        boolean firstLine = true;
        String readString = null;
        while ((readString = resultReader.readLine()) != null) {
            if (!firstLine) {
                buf.append("\n");
            }
            buf.append(readString);
            firstLine = false;
        }
        return buf.toString();
    }

    private static String appendParameterStringForList(ArrayList<Object> parameters, String encoding, String prefix) throws UnsupportedEncodingException {
        StringBuffer result = new StringBuffer();
        int idx = 0;
        int parameterSize = parameters.size();
        for (Object parameter : parameters) {
            if (parameter instanceof String) {
                result.append(prefix + (idx + 1) + "=" + URLEncoder.encode((String)parameter, encoding));
            } else if (parameter instanceof Boolean) {
                result.append(prefix + (idx + 1) + "=" + URLEncoder.encode(String.valueOf(parameter), encoding));
            } else if (parameter instanceof Integer) {
                result.append(prefix + (idx + 1) + "=" + URLEncoder.encode(String.valueOf(parameter), encoding));
            } else if (parameter instanceof Map) {
                Map map = (Map)parameter;
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() instanceof List) {
                        result.append(HttpConnectionUtil.appendParameterStringForList((ArrayList)entry.getValue(), encoding, prefix + (idx + 1) + "." + (String)entry.getKey() + "."));
                    } else if (entry.getValue() instanceof String) {
                        result.append(prefix + (idx + 1) + "." + (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), encoding));
                    } else if (entry.getValue() instanceof Boolean) {
                        result.append(prefix + (idx + 1) + "." + (String)entry.getKey() + "=" + URLEncoder.encode(String.valueOf(entry.getValue()), encoding));
                    } else if (entry.getValue() instanceof Number) {
                        Number num = (Number)entry.getValue();
                        DecimalFormat df = new DecimalFormat();
                        String numString = df.format(num);
                        numString = numString.replaceAll(",", "");
                        result.append(prefix + (idx + 1) + "." + (String)entry.getKey() + "=" + URLEncoder.encode(numString, encoding));
                    }
                    result.append("&");
                }
            } else if (parameter instanceof List) {
                result.append(HttpConnectionUtil.appendParameterStringForList((ArrayList)parameter, encoding, prefix + (idx + 1) + "."));
            }
            ++idx;
            result.append("&");
        }
        return result.toString();
    }

    private static String getPostParameter(Map<String, Object> parameters, String encoding, Boolean isDebug) throws UnsupportedEncodingException {
        StringBuffer postParameter = new StringBuffer();
        int parameterSize = parameters.entrySet().size();
        int idx = 0;
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (isDebug.booleanValue()) {
                logger.info("Parameter[" + idx + "]:" + entry.getKey() + ":" + entry.getValue());
            }
            if (entry.getValue() instanceof String) {
                postParameter.append(entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), encoding));
            } else if (entry.getValue() instanceof Boolean) {
                postParameter.append(entry.getKey() + "=" + URLEncoder.encode(String.valueOf(entry.getValue()), encoding));
            } else if (entry.getValue() instanceof Number) {
                Number num = (Number)entry.getValue();
                DecimalFormat df = new DecimalFormat();
                String numString = df.format(num);
                numString = numString.replaceAll(",", "");
                postParameter.append(entry.getKey() + "=" + URLEncoder.encode(numString, encoding));
            } else if (entry.getValue() instanceof List) {
                ArrayList objectList = (ArrayList)entry.getValue();
                String result = HttpConnectionUtil.appendParameterStringForList(objectList, encoding, entry.getKey() + ".");
                postParameter.append(result);
            }
            if (parameterSize == ++idx || entry.getValue() == null) continue;
            postParameter.append("&");
        }
        String result = postParameter.toString().replaceAll("&{2,}", "&");
        if (isDebug.booleanValue()) {
            logger.info(result);
        }
        return result;
    }

    public int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    public void setHttpConnectionTimeout(int httpConnectionTimeout) {
        this.httpConnectionTimeout = httpConnectionTimeout;
    }

    static enum METHOD {
        GET("GET"),
        POST("POST");

        private String name;

        private METHOD(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

