/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.common.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ncloud.api.cli.common.model.ProfileConfigure;
import com.ncloud.api.cli.common.util.GlobalOptionUtil;
import com.ncloud.api.cli.common.util.HttpConnectionUtil;
import com.ncloud.api.cli.common.util.PropertyMessageUtil;
import com.ncloud.api.cli.exception.NcloudCliException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public class ConfigureUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConfigureUtil.class);
    private static final List<ProfileConfigure> profileConfigureList = new ArrayList<ProfileConfigure>();
    private static final String metadata_api_url = "http://169.254.169.254/latest/meta-data/iam/security-credentials";

    public static Integer loadProfileConfigureList() throws IOException {
        int configureCount = 0;
        configureCount = ConfigureUtil.getProfileConfigureListViaConfigureFile();
        if (configureCount > 0) {
            return configureCount;
        }
        return ConfigureUtil.getProfileConfigureListViaMetadataApi();
    }

    public static Integer getProfileConfigureListViaMetadataApi() throws IOException {
        try {
            String roleId = HttpConnectionUtil.restCall(URI.create(metadata_api_url), HttpConnectionUtil.METHOD.GET.getName(), new HttpHeaders(), new HashMap<String, Object>(), false, 1, 3);
            if (GlobalOptionUtil.getIsDebug().booleanValue()) {
                logger.info("found roleId : " + roleId);
            }
            if (roleId == null) {
                return 0;
            }
            String credentialJsonString = HttpConnectionUtil.restCall(URI.create("http://169.254.169.254/latest/meta-data/iam/security-credentials/" + roleId), HttpConnectionUtil.METHOD.GET.getName(), new HttpHeaders(), new HashMap<String, Object>(), false);
            ObjectMapper objectMapper = new ObjectMapper();
            Map credentialMap = objectMapper.readValue(credentialJsonString, Map.class);
            String accessKeyId = (String)credentialMap.get("AccessKeyId");
            String secretAccessKey = (String)credentialMap.get("SecretAccessKey");
            if (credentialMap.size() == 0 || accessKeyId == null || secretAccessKey == null) {
                return 0;
            }
            if (GlobalOptionUtil.getIsDebug().booleanValue()) {
                logger.info("found accessKeyId : " + accessKeyId);
                logger.info("found secretAccessKey : " + secretAccessKey);
            }
            ArrayList<Map<String, String>> configureMapList = new ArrayList<Map<String, String>>();
            HashMap<String, String> configureMap = new HashMap<String, String>();
            configureMap.put("ncloud_access_key_id", accessKeyId);
            configureMap.put("ncloud_secret_access_key", secretAccessKey);
            configureMap.put("ncloud_api_url", PropertyMessageUtil.getMessage("ncloud.api.url"));
            configureMap.put("profile", "DEFAULT");
            configureMapList.add(configureMap);
            ConfigureUtil.setProfileConfigureList(configureMapList);
        }
        catch (Exception e) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getProfileConfigureListViaConfigureFile() {
        if (GlobalOptionUtil.getIsDebug().booleanValue()) {
            logger.info("" + System.getProperty("os.name"));
            logger.info("" + System.getProperty("user.home"));
            logger.info("" + System.getProperty("user.home") + File.separatorChar + ".ncloud" + File.separatorChar + "configure");
        }
        File configureFile = new File(ConfigureUtil.getConfigureFilePathName());
        File configureDirectory = new File(ConfigureUtil.getNcloudDirectoryPathName());
        if (!configureFile.exists()) {
            if (GlobalOptionUtil.getIsDebug().booleanValue()) {
                logger.info("there is no ~/.ncloud/configure file.");
            }
            return 0;
        }
        BufferedReader reader = null;
        ArrayList<Map<String, String>> configureMapList = new ArrayList<Map<String, String>>();
        try {
            String line;
            reader = new BufferedReader(new FileReader(configureFile));
            String regex = "\\[[\\w0-9.\\-_]+?]";
            String profile = null;
            HashMap<String, String> configureMap = null;
            while ((line = reader.readLine()) != null) {
                String[] words;
                if (line.matches(regex)) {
                    profile = line.substring(1, line.length() - 1);
                    if (GlobalOptionUtil.getIsDebug().booleanValue()) {
                        logger.info("found profile : " + profile);
                    }
                    configureMap = new HashMap<String, String>();
                    configureMap.put("profile", profile);
                    configureMapList.add(configureMap);
                }
                if (profile == null || configureMap == null || (words = StringUtils.split(line, "=")) == null || words.length != 2) continue;
                String key = words[0].trim();
                String value = words[1].trim();
                configureMap.put(key, value);
                if (!GlobalOptionUtil.getIsDebug().booleanValue()) continue;
                logger.info("found " + key + " : " + value);
            }
            ConfigureUtil.setProfileConfigureList(configureMapList);
        }
        catch (Exception e) {
            System.out.println("error occur while read configure file.");
            Integer n = 0;
            return n;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("", e);
                }
            }
        }
        if (configureMapList.size() == 0 && GlobalOptionUtil.getIsDebug().booleanValue()) {
            logger.info("there is no credential at ~/.ncloud/configure file");
        }
        return configureMapList.size();
    }

    private static void setProfileConfigureList(List<Map<String, String>> configureMapList) {
        profileConfigureList.clear();
        for (Map<String, String> configureMap : configureMapList) {
            ProfileConfigure profileConfigure = new ProfileConfigure(configureMap.get("profile"));
            profileConfigure.setAccessKey(configureMap.get("ncloud_access_key_id"));
            profileConfigure.setSecretKey(configureMap.get("ncloud_secret_access_key"));
            profileConfigure.setApiUrl(configureMap.get("ncloud_api_url"));
            profileConfigureList.add(profileConfigure);
        }
    }

    public static ProfileConfigure getProfileConfigure(String profile) {
        for (ProfileConfigure profileConfigure : profileConfigureList) {
            if (!StringUtils.equals(profile, profileConfigure.getProfile())) continue;
            return profileConfigure;
        }
        return null;
    }

    public static void setConfigures(ProfileConfigure profileConfigure, String accessKey, String secretKey, String apiUrl) {
        profileConfigure.setAccessKey(accessKey);
        profileConfigure.setSecretKey(secretKey);
        profileConfigure.setApiUrl(apiUrl);
        try {
            ConfigureUtil.makeConfigureFile();
        }
        catch (Exception e) {
            logger.error("", e);
        }
    }

    private static void makeConfigureFile() throws NcloudCliException {
        BufferedWriter writer = null;
        File configureFile = new File(ConfigureUtil.getConfigureFilePathName());
        File configureDirectory = new File(ConfigureUtil.getNcloudDirectoryPathName());
        if (!configureDirectory.exists()) {
            configureDirectory.mkdir();
        }
        try {
            writer = new BufferedWriter(new FileWriter(configureFile));
            for (ProfileConfigure profileConfigure : profileConfigureList) {
                String profile = profileConfigure.getProfile();
                String accessKey = profileConfigure.getAccessKey();
                String secretKey = profileConfigure.getSecretKey();
                String apiUrl = profileConfigure.getApiUrl();
                if (profile == null || accessKey == null || secretKey == null || apiUrl == null) continue;
                writer.write("[" + profile + "]");
                writer.newLine();
                writer.write("ncloud_access_key_id = " + accessKey);
                writer.newLine();
                writer.write("ncloud_secret_access_key = " + secretKey);
                writer.newLine();
                writer.write("ncloud_api_url = " + apiUrl);
                writer.newLine();
                writer.newLine();
            }
        }
        catch (Exception e) {
            logger.error("", e);
            throw new NcloudCliException(e.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ignore) {
                    logger.error("", ignore);
                }
            }
        }
    }

    public static void addProfileConfigure(ProfileConfigure profileConfigure) {
        if (StringUtils.equals(profileConfigure.getProfile(), "DEFAULT")) {
            profileConfigureList.add(0, profileConfigure);
        } else {
            profileConfigureList.add(profileConfigure);
        }
    }

    public static String getConfigureFilePathName() {
        return System.getProperty("user.home") + File.separatorChar + ".ncloud" + File.separatorChar + "configure";
    }

    public static String getNcloudDirectoryPathName() {
        return System.getProperty("user.home") + File.separatorChar + ".ncloud";
    }

    public static List<ProfileConfigure> getProfileConfigureList() {
        return profileConfigureList;
    }

    private ConfigureUtil() {
    }

    public static String getMetadataApiUrl() {
        return metadata_api_url;
    }
}

