/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.common.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.ncloud.api.cli.common.model.CommandOption;
import com.ncloud.api.cli.common.model.CommonResponse;
import com.ncloud.api.cli.common.model.NcloudApiRequest;
import com.ncloud.api.cli.common.options.GlobalOptions;
import com.ncloud.api.cli.common.util.AuthUtil;
import com.ncloud.api.cli.common.util.GlobalOptionUtil;
import com.ncloud.api.cli.common.util.HttpConnectionUtil;
import com.ncloud.api.cli.exception.NcloudCliException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CliCallUtil {
    private static final Logger logger = LoggerFactory.getLogger(CliCallUtil.class);

    public static void call(GlobalOptions globalOptions, NcloudApiRequest ncloudApiRequest, String requestUri, CommandOption commandOption) throws UnsupportedEncodingException, NcloudCliException {
        String requestMethod = "POST";
        CommonResponse commonResponse = new CommonResponse();
        String body = null;
        Date date = new Date();
        Timestamp timestamp = new Timestamp(date.getTime());
        String signature = AuthUtil.makeSignature(requestMethod, requestUri, timestamp.getTime() + "", ncloudApiRequest.getConsumerKey(), ncloudApiRequest.getConsumerSecret());
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        Map params = mapper.convertValue((Object)commandOption, Map.class);
        params.put("responseFormatType", globalOptions.getOutput().getCode());
        try {
            body = HttpConnectionUtil.restCall(URI.create(ncloudApiRequest.getRequestURL() + requestUri), requestMethod, AuthUtil.getApiHeaders(timestamp.getTime() + "", ncloudApiRequest.getConsumerKey(), signature), params, GlobalOptionUtil.getIsDebug());
            commonResponse = AuthUtil.getCommonResponseByFormat(globalOptions.getOutput().toString(), body);
        }
        catch (IOException e) {
            commonResponse.setReturnMessage(body);
        }
        if (!"0".equals(commonResponse.getReturnCode())) {
            throw new NcloudCliException(commonResponse.getReturnMessage());
        }
        System.out.println(body);
    }
}

